<?php

declare(strict_types=1);

namespace Drupal\Tests\mcp_server\Kernel;

use Drupal\KernelTests\KernelTestBase;
use Drupal\mcp_server\Entity\McpToolConfig;

/**
 * Tests the McpToolConfig entity CRUD operations.
 *
 * @group mcp_server
 */
final class McpToolConfigTest extends KernelTestBase {

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'tool',
    'mcp_server',
    'simple_oauth',
    'consumers',
    'serialization',
    'user',
    'system',
    'file',
    'image',
    'options',
  ];

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();
    $this->installEntitySchema('user');
    $this->installEntitySchema('file');
    $this->installEntitySchema('consumer');
    $this->installEntitySchema('oauth2_scope');
    $this->installEntitySchema('oauth2_token');
    $this->installConfig(['user', 'simple_oauth', 'tool', 'mcp_server']);
  }

  /**
   * Tests label() returns the configured tool name.
   */
  public function testMcpToolName(): void {
    // Test that mcp_tool_name is returned correctly via label().
    $config = McpToolConfig::create([
      'id' => 'tool_name_test',
      'mcp_tool_name' => 'Custom Tool Name',
      'tool_id' => 'module:tool_name',
      'status' => TRUE,
    ]);

    $this->assertEquals('Custom Tool Name', $config->label());
  }

  /**
   * Tests validation that tool_id is required.
   */
  public function testToolIdRequired(): void {
    $config = McpToolConfig::create([
      'id' => 'invalid_test',
      'mcp_tool_name' => 'Invalid Test',
      'status' => TRUE,
    ]);

    $this->expectException(\InvalidArgumentException::class);
    $this->expectExceptionMessage('The tool_id field is required.');
    $config->save();
  }

  /**
   * Tests setter validation with invalid authentication mode.
   */
  public function testAuthenticationModeValidation(): void {
    $config = McpToolConfig::create([
      'id' => 'test_auth_validation',
      'mcp_tool_name' => 'Test Auth Validation',
      'tool_id' => 'mcp_server_test:example',
      'status' => TRUE,
    ]);

    $this->expectException(\InvalidArgumentException::class);
    $this->expectExceptionMessage('Invalid authentication mode');
    $config->setAuthenticationMode('invalid_mode');
  }

}
