<?php

declare(strict_types=1);

namespace Drupal\Tests\mcp_server\Traits;

use Drupal\simple_oauth\Entity\Oauth2Scope;

/**
 * Provides helper methods for creating OAuth2 scope entities in tests.
 */
trait OAuth2ScopeTestTrait {

  /**
   * Creates OAuth2 scope entities for testing.
   *
   * @param array $scope_names
   *   Array of scope names to create (e.g., ['content:read', 'content:write']).
   *
   * @return array
   *   Array of created scope entity IDs, keyed by scope name.
   */
  protected function createOauthScopes(array $scope_names): array {
    $scope_ids = [];

    foreach ($scope_names as $scope_name) {
      // Convert ':' to '_' for valid entity IDs.
      $scope_id = strtr($scope_name, ':', '_');

      $scope = Oauth2Scope::create([
        'id' => $scope_id,
        'name' => $scope_name,
        'description' => "Test scope: {$scope_name}",
        'grant_types' => [],
      ]);
      $scope->save();

      $scope_ids[$scope_name] = $scope->id();
    }

    return $scope_ids;
  }

}
