<?php

/**
 * @file
 * Contains \Drupal\md_slider\Slider\MDSliderImport.
 */

namespace Drupal\md_slider\Slider;

use Drupal\md_slider\MDSlide;
use Drupal\md_slider\MDSlider;

use Drupal\Core\Messenger\MessengerInterface;
use Drupal\Core\Messenger;
use Drupal\Core\File;
class MDSliderImport {
  /**
   * List array images from file import
   * @var array
   */
  public $images;

  /**
   * List array slider data from file import
   * @var array
   */
  public $slider_data;


  /**
   * Get Data from file import and save data to array
   * @param $file_path
   * @param $destination_dir
   */  
  public function getDataImport($file_path, $destination_dir) {
    $zip = new \ZipArchive();
    $res = $zip->open($file_path);
    
    if ($res !== true) {
        throw new \Exception("Failed to open ZIP file: {$file_path}");
    }
    
    $images = [];
    $sliders = [];
    
    for ($i = 0; $i < $zip->numFiles; $i++) {
        $stat = $zip->statIndex($i);
        $entry_name = $stat['name'];
        
        // Skip the images directory itself
        if ($entry_name === "images/") {
            continue;
        }
        
        // Process import images
        if (str_starts_with($entry_name, "images/")) {
            $image_name = basename($entry_name);
            
            // Get image content
            $entry_content = $zip->getFromIndex($i);
            
            if ($entry_content === false) {
                continue;
            }
            
            // file_save_data is deprecated in Drupal 9, 10
            $image = \Drupal::hasService('file.repository') 
                ? \Drupal::service('file.repository')->writeData(
                    $entry_content, 
                    "{$destination_dir}/{$image_name}", 
                    \Drupal\Core\File\FileSystemInterface::EXISTS_RENAME
                  )
                : file_save_data(
                    $entry_content, 
                    "{$destination_dir}/{$image_name}", 
                    \Drupal\Core\File\FileSystemInterface::EXISTS_RENAME
                  );
            
            if ($image !== false) {
                $images[$image_name] = $image;
            }
        }
        elseif (str_contains($entry_name, "md_slider_")) {
            // Get slider data
            $slider_content = $zip->getFromIndex($i);
            if ($slider_content !== false) {
                $sliders[] = $slider_content;
            }
        }
    }
    
    $zip->close();
    
    $this->images = $images;
    $this->slider_data = $sliders;
  }
  
  /**
   * Import data form file import
   *
   */
  public function importDataSlider() {
    $sliders = $this->slider_data;
    $images = $this->images;
    $md_slider = new MDSlider();
    $md_slide = new MDSlide();

    foreach ($sliders as $slider_data) {
      // Get slider data
      $slider_data = unserialize($slider_data);
      $slider = $slider_data["slider"];
      $slides = $slider_data["slides"];

      // Save slider to database
      $slider->id = NULL;
      $md_slider->title = $slider->title;
      $md_slider->machine_name = $slider->machine_name;
      if ($md_slider::isSlider($slider->machine_name)){
        $md_slider->machine_name = "{$slider->machine_name}-".time();
        $md_slider->title = "{$slider->title}-".time();
      }
      $md_slider->description = $slider->description;
      $md_slider->settings = $slider->settings;
      $slid = $md_slider->saveDataSlider();
      $style = array();
      if (!$slid) {
		\Drupal::messenger()->addMessage($this->t("MD Slider: Import unsuccessful!"),MessengerInterface::TYPE_ERROR);
        //drupal_set_message(t("MD Slider: Import unsuccessful!"), "error");
        return;
      }

      // Save slides to database
      foreach ($slides as $slide) {
        $md_slide->sid = NULL;
        $md_slide->slid = $slid;

        // Get background and thumbnail settings after import
        if ($slide->settings['background_image'] != -1 && isset($images[$slide->settings['background_image']]))
          $slide->settings['background_image'] = $images[$slide->settings['background_image']]->id();
        else
          $slide->settings['background_image'] = -1;

        if ($slide->settings['custom_thumbnail'] != -1 && isset($images[$slide->settings['custom_thumbnail']]))
          $slide->settings['custom_thumbnail'] = $images[$slide->settings['custom_thumbnail']]->id();
        else
          $slide->settings['custom_thumbnail'] = -1;

        // Get file id of image and video item
        foreach ($slide->layers as &$layer) {
          switch ($layer["type"]) {
            case "video":
              if ($layer['fileid'] && isset($images[$layer['fileid']]))
                $layer['fileid'] = $images[$layer['fileid']]->id();
              break;

            case "image":
              if ($layer["fileid"] && isset($images[$layer["fileid"]]))
                $layer["fileid"] = $images[$layer["fileid"]]->id();
              break;
          }
        }
        $md_slide->position = $slide->position;
        $md_slide->settings = $slide->settings;
        $md_slide->layers = $slide->layers;
        $sid = $md_slide->saveDataSlider();
        foreach ($md_slide->layers as $key => &$layer) {
          $index = array($slid, $sid, $key);
          $css = new MDSliderRenderCss((object) $layer);
          $style = array_merge($style, $css->getCSS($index, $layer));
        }
      }
      MDSliderRenderCss::saveFileCss($md_slider->machine_name, $style);
    }
  }
}