# MD Sitemap

## Overview

**MD Sitemap** is a Drupal module that generates a dedicated sitemap designed for LLM (Large Language Model) crawlers.
Instead of only creating traditional `sitemap.xml` files for search engines, this module creates a separate sitemap endpoint that outputs URLs with a configurable suffix (e.g. `.md`, `.txt`, `.ai`), making it ideal for exposing machine-readable versions of your site's content.

This is particularly useful when paired with modules like [Markdownify](https://www.drupal.org/project/markdownify) to deliver clean Markdown or text-based pages optimized for AI ingestion.

## Features

* Provides a dedicated sitemap endpoint at:

  ```
  /sitemap-llm
  ```
* Configurable URL suffix (e.g. `.md`, `.txt`) depending on your preference and implementation of text based versions of your web pages.
* Admin UI to select **entity types** and **bundles** (e.g. nodes, taxonomy terms, media, commerce products).
* Automatically detects any entity type with a canonical URL.
* Automatic cache invalidation on:
  * Entity insert, update, delete.
  * Configuration changes.
* Lightweight and decoupled from SEO-specific sitemap modules.
* Compatible with `llms.txt` for LLM crawler directives. Just add a link to `/sitemap-llm`

## Usage

1. After installing the module, go to:

   ```
   /admin/config/search/md-sitemap
   ```
2. Configure:

   * **URL suffix** (default: `.md`).
   * **Entities and bundles** to include in the sitemap.
3. Visit the sitemap endpoint:

   ```
   /sitemap-llm
   ```

   This will output a plain-text list of URLs with the configured suffix.
4. (Optional) Reference the sitemap in your `llms.txt` file:

   ```
   Sitemap: https://yourdomain.com/sitemap-llm
   ```

## Requirements

* Drupal 10 or 11
* PHP 8.1+
* No external module dependencies (completely standalone)
* (Optional) [Markdownify](https://www.drupal.org/project/markdownify) - recommended if you want to generate `.md` versions of your pages.

## Installation

1. Download the module into your Drupal codebase:

   ```bash
   composer require drupal/mdsitemap
   ```
2. Enable the module:

   ```bash
   drush en mdsitemap
   ```

   or via **Extend → MD Sitemap** in the Drupal UI.
3. Configure it under:

   ```
   Configuration → Search and metadata → MD Sitemap
   ```
4. Test the sitemap by visiting:

   ```
   https://yourdomain.com/sitemap-llm
   ```

## Support & Contributions

* Issues and feature requests should be submitted via the project's issue queue.
* Merge requests and contributions are welcome! Please follow Drupal coding standards.
* For support, check:

  * [Drupal.org](https://www.drupal.org)
  * The module's issue queue if published publicly.

## Roadmap

* Integration with cron to pre-generate cached sitemaps.
* Support for multilingual URLs.

## License

This module is licensed under the [GPL v2.0](https://www.gnu.org/licenses/old-licenses/gpl-2.0.html), the same as Drupal core.
