<?php

namespace Drupal\Tests\mdsitemap\Functional;

use Drupal\node\Entity\NodeType;
use Drupal\Tests\BrowserTestBase;
use Drupal\user\UserInterface;
use PHPUnit\Framework\Assert;

/**
 * Tests that the form saves the suffix and entity bundles.
 *
 * @group mdsitemap
 */
class MdsitemapFormTest extends BrowserTestBase {

  /**
   * The default theme to use for the test.
   *
   * @var string
   */
  protected $defaultTheme = 'stark';

  /**
   * Modules to enable for this test.
   *
   * @var string[]
   */
  protected static $modules = ['user', 'node', 'mdsitemap'];

  /**
   * Sets up the environment for each test.
   */
  protected function setUp(): void {
    parent::setUp();

    // Create a "page" content type for the form to render the checkbox.
    NodeType::create([
      'type' => 'page',
      'name' => 'Page',
    ])->save();
  }

  /**
   * Tests form submission and verifies configuration is saved correctly.
   */
  public function testFormSubmission(): void {
    // Create and log in an admin user.
    $user = $this->createUser(['administer site configuration']);
    $this->assertInstanceOf(UserInterface::class, $user);
    $this->drupalLogin($user);

    // Visit the form.
    $this->drupalGet('admin/config/search/md-sitemap');
    $this->assertSession()->statusCodeEquals(200);

    // Submit the form.
    $edit = [
      'url_suffix' => '.txt',
      'entities[node][page]' => 'page',
    ];
    $this->submitForm($edit, 'Save configuration');

    // Load saved config and assert.
    $config = $this->config('mdsitemap.settings');
    Assert::assertSame('.txt', $config->get('url_suffix'));
    $entities = $config->get('entities');
    Assert::assertIsArray($entities, 'Entities config should be an array.');
    Assert::assertArrayHasKey('node', $entities, 'Entities config should have a "node" key.');
    Assert::assertSame(['page'], $entities['node']);
  }

}
