<?php

namespace Drupal\mdsitemap\Routing;

use Drupal\Core\Config\ConfigFactoryInterface;
use Drupal\Core\Routing\RouteSubscriberBase;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\Routing\RouteCollection;

/**
 * Alters the sitemap route path based on configuration.
 */
final class RouteSubscriber extends RouteSubscriberBase {

  /**
   * Constructs a RouteSubscriber object.
   */
  public function __construct(
    protected ConfigFactoryInterface $configFactory,
  ) {}

  /**
   * {@inheritdoc}
   */
  protected function alterRoutes(RouteCollection $collection): void {
    if ($route = $collection->get('mdsitemap.sitemap')) {
      $config = $this->configFactory->get('mdsitemap.settings');
      $path = $config->get('sitemap_path');

      if (!is_string($path) || $path === '') {
        $path = '/sitemap-llm';
      }

      if ($path[0] !== '/') {
        $path = '/' . $path;
      }

      if (strlen($path) > 1) {
        $path = rtrim($path, '/');
      }

      $route->setPath($path);
    }
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container): static {
    return new static(
      $container->get('config.factory'),
    );
  }

}
