<?php

namespace Drupal\Tests\mdsitemap\Kernel;

use Drupal\KernelTests\KernelTestBase;
use PHPUnit\Framework\Attributes\Group;

/**
 * Tests that the sitemap route path is configurable via admin settings.
 */
#[Group('mdsitemap')]
class MdsitemapRoutePathTest extends KernelTestBase {

  /**
   * {@inheritdoc}
   *
   * @var string[]
   */
  protected static $modules = [
    'system',
    'mdsitemap',
  ];

  /**
   * Tests default and configured sitemap route paths.
   */
  public function testRoutePathCanBeConfigured(): void {
    $this->installConfig(['mdsitemap']);

    // Default path should be '/sitemap-llm'.
    /** @var \Drupal\Core\Routing\RouteProviderInterface $provider */
    $provider = $this->container->get('router.route_provider');
    $route = $provider->getRouteByName('mdsitemap.sitemap');
    $this->assertSame('/sitemap-llm', $route->getPath());

    // Change the configuration and rebuild routes.
    $this->config('mdsitemap.settings')
      ->set('sitemap_path', '/custom-llm')
      ->save();

    \Drupal::service('router.builder')->rebuild();

    $route = $provider->getRouteByName('mdsitemap.sitemap');
    $this->assertSame('/custom-llm', $route->getPath());
  }

}
