<?php

namespace Drupal\mdsitemap\Controller;

use Drupal\Core\Controller\ControllerBase;
use Drupal\mdsitemap\MdsitemapGenerator;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\HttpFoundation\Response;

/**
 * Returns the Markdown sitemap as an HTTP response.
 */
final class SitemapController extends ControllerBase {

  public function __construct(
    protected MdsitemapGenerator $generator,
  ) {}

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container): static {
    return new static(
      $container->get('mdsitemap.generator'),
    );
  }

  /**
   * Builds the sitemap response.
   *
   * @return \Symfony\Component\HttpFoundation\Response
   *   The HTTP response containing the sitemap.
   */
  public function build(): Response {
    $content = $this->generator->generate();
    return new Response($content, 200, ['Content-Type' => 'text/markdown']);
  }

}
