<?php

namespace Drupal\mdsitemap\EventSubscriber;

use Drupal\Core\Cache\CacheBackendInterface;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

/**
 * Subscribes to entity CRUD events to invalidate the mdsitemap cache.
 */
class EntityChangeSubscriber implements EventSubscriberInterface {

  /**
   * The cache backend for mdsitemap.
   */
  protected CacheBackendInterface $cacheBackend;

  /**
   * Constructs a new EntityChangeSubscriber.
   */
  public function __construct(CacheBackendInterface $cache_backend) {
    $this->cacheBackend = $cache_backend;
  }

  /**
   * {@inheritdoc}
   */
  public static function getSubscribedEvents(): array {
    return [
      'entity.insert' => 'invalidateSitemapCache',
      'entity.update' => 'invalidateSitemapCache',
      'entity.delete' => 'invalidateSitemapCache',
    ];
  }

  /**
   * Invalidates mdsitemap cache when entity is inserted, updated, or deleted.
   */
  public function invalidateSitemapCache(): void {
    $this->cacheBackend->deleteAll();
  }

}
