# Mercury Editor Language Visibility

This module allows a content editor to exempt individual paragraphs from display
by language.  However, since Mercury Editor is a visual editor, the paragraph
always displays in the editor.

## Table of contents

- Requirements
- Recommended modules
- Installation
- Configuration
- DDEV assisted Development
- Maintainers

## Requirements

This module is intended to work with Mercury Editor, which is listed as a
dependency.

## Installation

Install as you would normally install a contributed Drupal module. For further
information, see [Installing Drupal Modules](https://www.drupal.org/docs/extending-drupal/installing-drupal-modules).

## Configuration

This module provides a Paragraph Behavior.  Enable the behavior in the entity
level configuration of each paragraph type that this behavior is desired.

By default, paragraphs will continue to be available in all enabled languages.
Each paragraph will have a language visibility `details` element on the _Styles_
tab.

## DDEV assisted Development

The repository is setup to use [DDEV Drupal Contrib](https://github.com/ddev/ddev-drupal-contrib)

To work on this module locally:

1. [Install DDEV](https://ddev.readthedocs.io/en/latest/users/install/) if you
   aren't yet using this approach.
2. `ddev start` to start up your local project
3. `ddev poser` to get all the dependencies
4. `ddev symlink-project` to connect everything.
5. `ddev restart`
More info on the commands is in the add-on [README.md](https://github.com/ddev/ddev-drupal-contrib?tab=readme-ov-file#commands)

## Maintainers

- Shawn Duncan - [FatherShawn](https://www.drupal.org/u/fathershawn)
