# Media Accessibility Audit

Media Accessibility Audit is a Drupal 11 module that helps site builders and editors
identify, review, and improve image accessibility by auditing alt text quality and
providing AI-assisted, WCAG-conscious suggestions.

The module focuses on **analysis and guidance**, not automatic content mutation.
All AI-generated suggestions are **read-only previews** and are only applied when
explicitly confirmed by an administrator.

Key goals:
- Improve accessibility compliance (WCAG 2.x)
- Support editorial workflows
- Use AI responsibly and transparently
- Avoid silent or automatic content changes

---

## Table of contents

- Requirements
- Recommended modules
- Installation
- Configuration
- Usage
- Troubleshooting & FAQ
- Maintainers

---

## Requirements

- Drupal 11.x
- Core Media module (enabled)
- Core Image module (enabled)
- Drupal AI module (`drupal/ai`)
- An AI provider configured via the AI module

Supported AI providers depend on the AI module configuration.
Vision-based suggestions are only enabled if the selected model supports image input.

---

## Recommended modules

- **AI** (`drupal/ai`)
  Required for generating alt text suggestions.

- **Media Library** (core)
  Improves the editorial experience when reviewing media items.

- **Admin Toolbar**
  Helpful for navigating audit dashboards quickly.

---

## Installation

1. Install the module as usual:
   composer require drupal/media_accessibility_audit

2. Enable the module:
   drush en media_accessibility_audit

3. Ensure the Media and Image core modules are enabled.

4. Configure an AI provider under:
   Administration » Configuration » AI

## Configuration
After enabling the module:

Navigate to:
Administration » Content » Media Accessibility Audit

# The dashboard displays:

- Media items with accessibility scores
- Detected alt text issues
- Confidence indicators
- AI-generated alt text suggestions (preview only)

# Optional features:

- Refresh AI suggestions per media item
- Apply suggested alt text individually or in bulk
- Run batch audits for large media libraries

# AI behavior notes

- AI suggestions are never saved automatically
- Suggestions are generated using:
  - Stored alt text
  - Media context
  - Optional parent node context

- Vision models are used only when supported by the active AI provider

## Usage
# Media audit dashboard

Use the dashboard to:

- Review accessibility issues
- See alt text quality scoring
- Preview AI suggestions safely

# Batch audit (UI)

Large media libraries can be audited using Drupal’s Batch API from the UI.

# Drush command

Run audits from the command line:

drush media_accessibility_audit:audit (aliase - drush maa-audit)


Batch-safe mode for large sites:

drush media_accessibility_audit:audit --batch (aliase - drush maa-audit --batch)

## Troubleshooting & FAQ

# AI suggestions show low confidence

# AI suggestions show low confidence
This usually indicates that:

- A non-vision AI model is active, or
- The AI response was generated without image input.

# No issues detected, but issues are expected

- Ensure the media items use the image media bundle.
- Confirm alt text is stored directly on the image field.

# AI quota exceeded

- The module fails gracefully and displays a warning.
- Retry after a short delay or check provider limits.

# Does this module modify content automatically?
No. All content changes require explicit user action.

Maintainers

Zeeshan Khan - [zeeshan_khan]https://www.drupal.org/u/zeeshan_khan

Contributions, issues, and feature requests are welcome via the Drupal.org issue queue.