<?php

namespace Drupal\media_accessibility_enhancer\Annotation;

use Drupal\Component\Annotation\Plugin;

/**
 * Defines a MediaDistantProvider item annotation object.
 *
 * @see \Drupal\MediaDistantProvider\Plugin\MediaDistantProviderPluginManager
 * @see plugin_api
 *
 * @Annotation
 */
class MediaDistantProvider extends Plugin {

  /**
   * The plugin ID.
   *
   * @var string
   */
  public $id;

  /**
   * The label of the plugin.
   *
   * @var \Drupal\Core\Annotation\Translation
   *
   * @ingroup plugin_translatable
   */
  public $label;

  /**
   * The oembed provider name.
   *
   * @var string
   */
  public $oembed_provider;

}
