<?php

namespace Drupal\media_accessibility_enhancer\Plugin;

use Drupal\Component\Plugin\PluginInspectionInterface;
use Drupal\media\OEmbed\Resource;

/**
 * Defines an interface for Media Distant provider plugins.
 */
interface MediaDistantProviderInterface extends PluginInspectionInterface {

  /**
   * Get transcription from API or other provider.
   *
   * @param ?\Drupal\media\OEmbed\Resource $resource
   *   This is resource from oembed.
   * @param string $url
   *   This is url.
   * @param string $language
   *   This is language.
   *
   * @return string
   */
  public function getTranscription(?Resource $resource, string $url, string $language): string;

  /**
   * Get duration from API or other provider.
   *
   * @param ?\Drupal\media\OEmbed\Resource $resource
   *   This is resource from oembed.
   * @param string $url
   *   This is url.
   *
   * @return string
 */
  public function getDuration(?Resource $resource, string $url): string;

  /**
   * Give a render array from form api of settings needed for the current provider.
   *
   * @param ?array $config
   *   This current configuration.
   *
   * @return array
 */
  public function defineSettings(?array $config): array;

  /**
   * Get settings from settings form values.
   *
   * @return array
   */
  public function getSettings(): array;

  /**
   * Get information from oembed
   *
   * @param string $url
   *
   * @return Resource|null
   */
  public function getResourceInformation(string $url): ?Resource;

}
