<?php

namespace Drupal\media_accessibility_enhancer\Plugin;

use Drupal\Core\Plugin\DefaultPluginManager;
use Drupal\Core\Cache\CacheBackendInterface;
use Drupal\Core\Extension\ModuleHandlerInterface;

/**
 * Provides the Media Distant Provider plugin manager.
 */
class MediaDistantProviderPluginManager extends DefaultPluginManager {

  /**
   * Constructs a new MediaDistantProviderPluginManager object.
   *
   * @param \Traversable $namespaces
   *   An object that implements \Traversable which contains the root paths
   *   keyed by the corresponding namespace to look for plugin implementations.
   * @param \Drupal\Core\Cache\CacheBackendInterface $cache_backend
   *   Cache backend instance to use.
   * @param \Drupal\Core\Extension\ModuleHandlerInterface $module_handler
   *   The module handler to invoke the alter hook with.
   */
  public function __construct(\Traversable $namespaces, CacheBackendInterface $cache_backend, ModuleHandlerInterface $module_handler) {
    parent::__construct('Plugin/MediaDistantProvider', $namespaces, $module_handler, 'Drupal\media_accessibility_enhancer\Plugin\MediaDistantProviderInterface', 'Drupal\media_accessibility_enhancer\Annotation\MediaDistantProvider');

    $this->alterInfo('media_distant_provider_plugin_info');
    $this->setCacheBackend($cache_backend, 'media_distant_provider_plugin_plugins');
  }

}
