<?php

namespace Drupal\media_accessibility_enhancer\Plugin\Field\FieldFormatter;

use Drupal\Core\Field\FieldItemListInterface;
use Drupal\Core\Field\FormatterBase;

/**
 * Plugin implementation of the 'video_duration_formatter' formatter.
 *
 * @FieldFormatter(
 *   id = "video_duration_formatter",
 *   label = @Translation("Video Duration Formatter"),
 *   field_types = {
 *     "video_duration"
 *   }
 * )
 */
class VideoDurationFormatter extends FormatterBase {

  /**
   * {@inheritdoc}
   */
  public function settingsSummary() {
    return [];
  }

  /**
   * {@inheritdoc}
   */
  public function viewElements(FieldItemListInterface $items, $langcode) {
    $elements = [];

    foreach ($items as $delta => $item) {
      $elements[$delta] = [
        '#markup' => $item->seconds,
      ];
    }

    return $elements;
  }

}
