<?php

namespace Drupal\media_accessibility_enhancer\Plugin\Field\FieldFormatter;

use Drupal\Core\Field\FieldItemListInterface;
use Drupal\Core\Field\FormatterBase;

/**
 * Plugin implementation of the 'video_transcription_formatter' formatter.
 *
 * @FieldFormatter(
 *   id = "video_transcription_formatter",
 *   label = @Translation("Video Transcription Formatter"),
 *   field_types = {
 *     "video_transcription"
 *   }
 * )
 */
class VideoTranscriptionFormatter extends FormatterBase {

  /**
   * {@inheritdoc}
   */
  public function settingsSummary() {
    return [];
  }

  /**
   * {@inheritdoc}
   */
  public function viewElements(FieldItemListInterface $items, $langcode) {
    $elements = [];

    foreach ($items as $delta => $item) {
      $elements[$delta] = [
        '#type' => 'html_tag',
        '#tag' => 'div',
        '#value' => nl2br(htmlspecialchars($item->transcription)),
        '#attributes' => ['class' => ['transcription-text']],
      ];
    }

    return $elements;
  }

}
