<?php

namespace Drupal\media_accessibility_enhancer\Plugin\Field\FieldType;

use Drupal\Core\Field\FieldItemBase;
use Drupal\Core\Field\FieldStorageDefinitionInterface;
use Drupal\Core\TypedData\DataDefinition;

/**
 * Plugin implementation of the 'video_duration' field type.
 *
 * @FieldType(
 *   id = "video_duration",
 *   label = @Translation("Video Duration"),
 *   description = @Translation("Store video duration in seconds with formatted display"),
 *   default_widget = "video_duration_widget",
 *   default_formatter = "video_duration_formatter"
 * )
 */
class VideoDurationItem extends FieldItemBase {

  /**
   * {@inheritdoc}
   */
  public static function propertyDefinitions(FieldStorageDefinitionInterface $field_definition) {
    $properties['seconds'] = DataDefinition::create('integer')
      ->setLabel(t('Duration in seconds'))
      ->setRequired(TRUE);

    return $properties;
  }

  /**
   * {@inheritdoc}
   */
  public static function schema(FieldStorageDefinitionInterface $field_definition) {
    return [
      'columns' => [
        'seconds' => [
          'type' => 'int',
          'unsigned' => TRUE,
          'not null' => FALSE,
        ],
      ],
      'indexes' => [
        'seconds' => ['seconds'],
      ],
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function isEmpty() {
    $value = $this->get('seconds')->getValue();
    return $value === NULL || $value === '';
  }

}
