# Media Duplicate Check

The Media Duplicate Check module prevents accidental duplicate media uploads by checking filenames and showing existing media items.

## Features

- **Duplicate Detection**: Automatically checks for existing media files with the same filename during upload
- **Visual Preview**: Shows thumbnails and details of existing media items with the same filename  
- **Configurable**: Admin settings to control which media types are checked and how the module behaves
- **AJAX-powered**: Real-time checking without page reloads
- **Multiple Media Type Support**: Works with images, documents, SVG files, videos, and audio files
- **Translation Ready**: Supports multilingual sites with translatable strings

## Requirements

- Drupal 10.0+ or Drupal 11.0+
- Media module (core)
- File module (core)

## Installation

### Via Composer (Recommended)

```bash
composer require drupal/media_duplicate_check
drush en media_duplicate_check
```

### Manual Installation

1. Download and extract the module to `/modules/contrib/media_duplicate_check`
2. Enable the module:
   ```bash
   drush en media_duplicate_check
   ```
3. Clear the cache:
   ```bash
   drush cr
   ```

## Configuration

Navigate to **Configuration > Media > Media Duplicate Check** (`/admin/config/media/duplicate-check`) to configure the module.

### Basic Settings

- **Enable duplicate checking**: Turn the duplicate checking on/off
- **Check media types**: Select which media types to check (Image, Document, SVG, Video, Audio, etc.)

### Advanced Settings

- **Check filename only**: Compare only filenames (vs. also checking file hash)
- **Case-sensitive comparison**: Enable case-sensitive filename matching

## How It Works

1. When a user uploads a file through a media form, the module intercepts the upload
2. It queries the database for existing media with the same filename
3. If duplicates are found:
   - A warning message is displayed
   - Existing media items are shown with:
     - Media name and type
     - Creation date  
     - File size
     - Link to view the existing media
4. The upload proceeds normally

## Supported Forms

The module works with:
- Media add/edit forms (`/media/add/*`, `/media/*/edit`)
- Media library upload forms  
- Inline entity forms for media
- Any form using standard Drupal media upload fields

## Permissions

The module respects standard Drupal media permissions:
- Users must have permission to create media to see the duplicate check
- Admin configuration requires "administer site configuration" permission

## Compatibility

- Drupal 10.x and 11.x
- Requires Media module (core)
- Works with all standard media types
- Compatible with Media Library module

## Support

For bug reports and feature requests, please use the [issue queue](https://www.drupal.org/project/issues/media_duplicate_check).

## Contributing

Contributions are welcome! Please:
1. Fork the project on Drupal.org
2. Create a feature branch
3. Make your changes following Drupal coding standards
4. Include tests for new functionality
5. Submit a merge request

## License

This project is licensed under the same terms as Drupal core (GPL v2 or later).

## Credits

2. Check configuration at `/admin/config/media/duplicate-check`
3. Verify the media type is selected in settings
4. Clear Drupal cache

### False positives/negatives
1. Check case-sensitive setting in configuration
2. Verify file directory settings in media type configuration
3. Review filename comparison settings

## API Usage

Other modules can use the duplicate checker service:

```php
// Get the duplicate checker service.
$duplicate_checker = \Drupal::service('media_duplicate_check.duplicate_checker');

// Find duplicates for a filename.
$duplicates = $duplicate_checker->findDuplicatesByFilename('example.pdf', 'document');

// Get preview data for a media entity.
$preview_data = $duplicate_checker->getMediaPreviewData($media_entity);
```

## Support

For issues or feature requests, please contact the development team.

## License

This module is available as a contributed module for Drupal.org.
