<?php

namespace Drupal\media_entity_instagram\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Form\RedundantEditableConfigNamesTrait;

/**
 * Provides a form to configure Instagram credentials.
 */
class InstagramSettingsForm extends ConfigFormBase {

  use RedundantEditableConfigNamesTrait;

  /**
   * {@inheritdoc}
   */
  public function getFormId(): string {
    return 'media_entity_instagram_settings_form';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state): array {
    $form['credentials'] = [
      '#type' => 'details',
      '#title' => $this->t('Facebook credentials'),
      '#description' => $this->t('To use this module you need a Facebook developer account. In the your Facebook developer dashboard you have to create an App that uses the oEmbed API.'),
      '#open' => TRUE,
    ];

    $form['credentials']['facebook_app_id'] = [
      '#type' => 'textfield',
      '#title' => $this->t('App ID'),
      '#size' => 40,
      '#maxlength' => 255,
      '#description' => $this->t('The ID of your Facebook App.'),
      '#config_target' => 'media_entity_instagram.settings:facebook_app_id',
    ];

    $form['credentials']['facebook_app_secret'] = [
      '#type' => 'textfield',
      '#title' => $this->t('App secret'),
      '#size' => 40,
      '#maxlength' => 255,
      '#description' => $this->t('The secret of your Facebook App.'),
      '#config_target' => 'media_entity_instagram.settings:facebook_app_secret',
    ];
    return parent::buildForm($form, $form_state);
  }

}
