<?php

namespace Drupal\media_field_formatters\Plugin\Field\FieldFormatter;

use Drupal\Core\Field\Attribute\FieldFormatter;
use Drupal\Core\Field\FieldItemListInterface;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\file\Plugin\Field\FieldFormatter\FileFormatterBase;

/**
 * Plugin implementation of the 'image_alt_text' formatter.
 */
#[FieldFormatter(
  id: 'image_alt_text',
  label: new TranslatableMarkup('Image alt text'),
  field_types: [
    'image',
  ],
)]
class ImageAltText extends FileFormatterBase {

  /**
   * {@inheritdoc}
   */
  public function viewElements(FieldItemListInterface $items, $langcode) {
    $elements = [];

    /** @var \Drupal\file\FileInterface[] $images */
    foreach ($items as $delta => $item) {
      $elements[$delta] = ['#markup' => $item->alt ?? ''];
    }

    return $elements;
  }

}
