# Media Image Style Formatter

Extends Drupal core's "Rendered entity" formatter for media reference fields to allow overriding the image style (or displaying the original image) directly in the field formatter settings—natively and seamlessly, without creating extra view modes on the media entity.

## Features

- **Native integration**: Enhances the existing core "Rendered entity" formatter (no new formatter to select).
- Works automatically in both entity Manage Display and Views field configurations.
- Allows overriding any image field inside the Image media entity (defaults to `field_media_image`, supports custom fields).
- Option to apply a specific image style or "None (original image)" to show the full-size, uncropped original.
- Preserves the full rendered media context (captions, alt/title, links, other fields) while only changing the image style.
- Automatically detects available image fields across allowed media bundles and base fields.
- Proper cache handling for reliable performance.
- Lightweight – no dependencies beyond core Media module.

## Why use this module?

In Drupal core, changing the image size/style for a reused Image media entity in different contexts (teasers, full page, Views, blocks, etc.) requires creating multiple view modes on the media bundle itself. This quickly leads to configuration bloat and maintenance overhead.

This module solves that by letting you override the image style **per display context** while keeping a single view mode on the media entity.

Common use cases:
- Small thumbnail in teasers/lists, larger image on full node view.
- Original uncropped image in galleries/lightboxes, cropped styles elsewhere.
- Different styles in various Views or paragraph displays without duplicating media.

## Requirements

- Drupal ^9 || ^10 || ^11
- Core **Media** module enabled
- At least one Image media bundle with an image field (core default: `field_media_image`)

## Installation

1. Install and enable the module as usual (via Composer, Drush, or UI).
2. Clear caches if necessary.

No additional configuration pages are created.

## Usage

### In entity display (Manage display)

1. Go to **Manage display** for an entity type (node, paragraph, block type, etc.) that has a media reference field restricted to Image bundles.
2. For the media field, ensure the formatter is set to **Rendered entity** (it is now enhanced by this module).
3. Click the gear icon to open formatter settings.
4. Check **Override entity image style**.
5. Select the image field to override (usually `field_media_image`).
6. Choose the desired image style or **None (original image)**.
7. Save the display settings.

### In Views

1. Add or edit a media reference field in a View.
2. Set the formatter to **Rendered entity**.
3. In the field style settings, the same override options will appear.
4. Configure as needed and save the View.

The override applies only to that specific display context.

## Notes

- Works exclusively with **Image** media types.
- Does not affect non-image media (video, document, remote video, etc.).
- If you need responsive images, combine with core Responsive Image module or other tools – this module works with standard image styles.

## Recommended complementary modules

- **Focal Point** or **Image Widget Crop** – for better cropping control across styles.
- Core **Responsive Image** module – for responsive variants.
- **Blazy** – for lazy-loading and performance on image-heavy pages.
- **Entity Browser** – improved media selection workflow.

## Similar modules

- **Media Responsive Thumbnail** – adds a dedicated responsive thumbnail formatter.
- **RIFT (Responsive Image Formatter Tools)** – advanced responsive image handling with custom view modes.
- **Field Formatter** – generic field rendering from referenced entities (loses full media context).

This module stands out by natively enhancing the standard "Rendered entity" formatter while keeping everything lightweight and focused.

## Support & Contributions

Bugs, feature requests, patches, and translations are welcome on the [Drupal.org project page](https://www.drupal.org/project/...).

No sponsorship links yet – contributions to the issue queue are greatly appreciated!

---