<?php

namespace Drupal\media_kinescope\Plugin\Field\FieldWidget;

use Drupal\Core\Field\FieldDefinitionInterface;
use Drupal\Core\Field\FieldItemListInterface;
use Drupal\Core\Field\Plugin\Field\FieldWidget\StringTextfieldWidget;
use Drupal\Core\Form\FormStateInterface;
use Drupal\media\Entity\MediaType;
use Drupal\media_kinescope\Plugin\media\Source\KinescopeVideo;

/**
 * Plugin implementation of the 'kinescope_video_textfield' widget.
 *
 * @FieldWidget(
 *   id = "kinescope_video_textfield",
 *   label = @Translation("Kinescope Video URL"),
 *   field_types = {
 *     "string",
 *   },
 * )
 */
class KinescopeVideoWidget extends StringTextfieldWidget {

  /**
   * {@inheritdoc}
   */
  public function formElement(FieldItemListInterface $items, $delta, array $element, array &$form, FormStateInterface $form_state) {
    $element = parent::formElement($items, $delta, $element, $form, $form_state);

    $message = $this->t('You can link to media from the kinescope.io service');

    if (!empty($element['value']['#description'])) {
      $element['value']['#description'] = [
        '#theme' => 'item_list',
        '#items' => [$element['value']['#description'], $message],
      ];
    }
    else {
      $element['value']['#description'] = $message;
    }

    return $element;
  }

  /**
   * {@inheritdoc}
   */
  public static function isApplicable(FieldDefinitionInterface $field_definition) {
    $target_bundle = $field_definition->getTargetBundle();

    if (!parent::isApplicable($field_definition) || $field_definition->getTargetEntityTypeId() !== 'media' || !$target_bundle) {
      return FALSE;
    }
    $a = MediaType::load($target_bundle)->getSource();
    return MediaType::load($target_bundle)->getSource() instanceof KinescopeVideo;
  }

}
