<?php

namespace Drupal\media_kinescope;

/**
 * Defines an interface for an kinescope.io resource fetcher service.
 *
 * The resource fetcher's only responsibility is to retrieve kinescope.io resource
 * data from an endpoint URL.
 */
interface ResourceFetcherInterface {

  /**
   * Fetches an kinescope.io resource.
   *
   * @param string $url
   *   Endpoint-specific URL of the resource.
   * @param string $apiKey
   *   Api key for access to the resource.
   *
   * @return \Drupal\media_kinescope\Resource
   *   A resource object built from the kinescope.io resource data.
   *
   * @throws \Drupal\media_kinescope\ResourceException
   *   If the kinescope.io endpoint is not reachable or the response returns an
   *   unexpected Content-Type header.
   */
  public function fetchResource($url, $apiKey);

}
