(function (Drupal, once) {

  'use strict';

  function showVideoPopup(element){
    const videoPopupButton = element.closest('.video-item').querySelector('.video-popup-button');
    const videoTitle = videoPopupButton.getAttribute('alt');
    const videoUrl = videoPopupButton.getAttribute('data-src-url');
    const modalHtml = `<iframe class="kinescope-popup-iframe" src="${videoUrl}" allow="fullscreen; picture-in-picture; encrypted-media; gyroscope; accelerometer; clipboard-write;" frameBorder="0" allowFullScreen="true"></iframe>`;
    let modal = Drupal.dialog(modalHtml, {
      title: videoTitle,
      width: 800,
      height: 450,
      autoResize: true,
      close: function (event) {
        modal.close();
        event.target.remove();
      }
    });
    modal.showModal();
  }

  Drupal.behaviors.kinescopePopup = {
    attach: function (context) {
      const videoPopupButtons = once('video-popup-button', '.video-popup-button', context);
      if (videoPopupButtons.length > 0) {
        videoPopupButtons.forEach(videoPopupButton => {
          videoPopupButton.closest('.video-item').querySelector('.field--name-name').addEventListener('click', function (event) {
            showVideoPopup(event.target);
          });
          videoPopupButton.addEventListener('click', function (event) {
            showVideoPopup(event.target);
          });
        });
      }
    }
  };

}(Drupal, once));
