# Media Library Thumbnail Override

This Drupal module overrides the default thumbnails for non-image media items in the Media Library, displaying custom icons based on the file extension instead of generic placeholders.

## Features

- Automatically detects file extensions for media items (documents, videos, audio, etc.)
- Displays extension-specific icons (e.g., `pdf.png` for PDF files)
- Falls back to a generic icon if no extension-specific icon exists
- Applies the `media_library` image style for consistent sizing (220x220 pixels)
- Maintains proper HTML markup and CSS classes for seamless integration

## Requirements

- Drupal 10 or 11
- Media module (included in Drupal core)

## Installation

1. Place the `media_thumbnail_override` module in your `web/modules/custom/` directory.
2. Enable the module via Drush: `drush en media_thumbnail_override`
3. Clear the Drupal caches: `drush cr`

## Configuration

1. The module uses the icon directory specified in the Media module settings (`/admin/config/media/media-settings`).
   - The default path is `public://media-icons/generic/`
   - You can change this in the Media settings if needed.

2. Create the icon directory (e.g., `web/sites/default/files/media-icons/generic/`) if it doesn't exist.

3. Add PNG icon files to this directory, named after file extensions:
   - `pdf.png` for PDF files
   - `doc.png` for Word documents
   - `docx.png` for Word documents
   - `xls.png` for Excel files
   - `mp4.png` for MP4 videos
   - `mp3.png` for MP3 audio files
   - `generic.png` for fallback (any file type without a specific icon)

4. Ensure icons are square dimensions (e.g., 256x256 pixels) for best results with the image style cropping.

## How It Works

- The module uses `hook_entity_view_alter` to modify the thumbnail display for media items in the `media_library` view mode.
- Only affects file-based media types (not remote videos or other non-file sources).
- Checks for the existence of extension-specific icons before applying overrides.
- Generates styled image URLs using Drupal's image processing system.

## File Structure

```
media_thumbnail_override/
├── media_thumbnail_override.info.yml
├── media_thumbnail_override.module
└── README.md
```

## Troubleshooting

- If thumbnails don't update, clear the Drupal caches.
- Ensure icon files are accessible and in the correct directory.
- Check the Drupal logs for any errors related to image processing.
- Verify that the `media_library` image style is configured correctly.

## Compatibility

- Tested with Drupal 10 and 11
- Compatible with all file-based media types
- Works with the core Media Library interface

## Contributing

Feel free to submit issues or pull requests to improve this module.