# Media Link Enhancements

The purpose of this module is to provide enhancements for media links. This
includes things like allowing the links to point directly to files instead of
their canonical media entity URLs, appending file type and size for 508
accessibility requirements, etc.

For a full description of the module, visit the
[project page](https://www.drupal.org/project/media_link_enhancements)

Submit bug reports and feature suggestions, or track changes in the
[issue queue](https://www.drupal.org/project/issues/search/media_link_enhancements)


## Table of contents

- Requirements
- Recommended modules
- Installation
- Configuration
- Maintainers


## Requirements

Core's media module with the "Standalone media URL" setting enabled.


## Recommended modules

[Linkit](https://www.drupal.org/project/linkit)
- provides an interface for selecting media for linking in WYSIWYG
  fields.

[Linkit for Link field](https://www.drupal.org/project/linkit/issues/2712951)
- provides an interface for selecting media when
  populating a standard Drupal link field.


## Installation

Install as you would normally install a contributed Drupal module. For further
information, see
[Installing Drupal Modules](https://www.drupal.org/docs/extending-drupal/installing-drupal-modules).


## Configuration

Enable and configure the module features by visiting:
Home > Administration > Configuration > System > Configure Media Link
Enhancements

The module provides an interface where media bundles may be selected for
application of provided enhancements.


## Maintainers

Current maintainers:
- Cameron Prince - [cameron prince](https://www.drupal.org/u/cameronprince)
