<?php

declare(strict_types = 1);

namespace Drupal\media_opengraph\Hook;

use Drupal\Core\Hook\Attribute\Hook;

/**
 * Media Hooks.
 */
class MediaHooks {

  /**
   * Implements hook_theme().
   */
  #[Hook('theme')]
  public function theme(array $existing, string $type, string $theme, string $path): array {
    return [
      'media__link_preview' => [
        'base hook' => 'media',
      ],
    ];
  }

  /**
   * Implements hook_preprocess_HOOK().
   */
  #[Hook('preprocess_media')]
  public function preprocessMedia(array &$variables): void {
    /** @var \Drupal\media\Entity\Media $media */
    $media = $variables['media'];
    if ($media->getSource()->getPluginId() === 'link_preview') {
      if (isset($variables["content"]["field_meta_image"][0])) {
        $variables["content"]["field_meta_image"][0]['#template'] = "<img src='{{value}}' alt='{{title}}'/>";
        $variables["content"]["field_meta_image"][0]['#context']['title'] = $media->getName();
      }
      $variables['link'] = $media->get('field_media_link_preview')->value;
      $variables['#attached']['library'] = 'media_opengraph/link_preview';
    }
  }

}
