<?php

declare(strict_types=1);

namespace Drupal\Tests\media\FunctionalJavascript;

/**
 * Basic display tests for Media.
 *
 * @group media
 */
class MediaDisplayTest extends MediaJavascriptTestBase {

  /**
   * {@inheritdoc}
   */
  protected $defaultTheme = 'stark';

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'path',
    'link',
    'media_opengraph',
  ];

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();

    // This test is going to test the display, so we need the standalone URL.
    \Drupal::configFactory()
      ->getEditable('media.settings')
      ->set('standalone_url', TRUE)
      ->save(TRUE);

    $this->container->get('router.builder')->rebuild();
  }

  /**
   * Test media creation.
   */
  public function testMedia(): void {
    $assert_session = $this->assertSession();
    $page = $this->getSession()->getPage();

    $this->drupalGet('media/add/link_preview');
    $page->fillField('field_media_link_preview[0][value]', 'https://developer.mozilla.org');
    $page->pressButton('Save');
    $image_media_id = $this->container
      ->get('entity_type.manager')
      ->getStorage('media')
      ->getQuery()
      ->accessCheck(FALSE)
      ->sort('mid', 'DESC')
      ->execute();
    $image_media_id = reset($image_media_id);

    // Go to the media entity view.
    $this->drupalGet('/media/' . $image_media_id);

    // Check if the default media name is generated as expected.
    $assert_session->elementTextContains('xpath', '//h1', 'MDN Web Docs');
    $assert_session->elementTextContains('xpath', '//article', 'The MDN Web Docs site provides information');
  }

}
