# CONTENTS OF THIS FILE

* Introduction
* Recommended modules
* Installation
* Configuration
* Troubleshooting & guides
* Maintainers & contribution

## INTRODUCTION

The Mediaflow module provides integration between Drupal and the Mediaflow
digital asset management platform, enabling editors to browse, search, and
import Mediaflow assets directly into Drupal’s media system.

* For full documentation and usage instructions, visit:
  https://help.mediaflow.com/hc/en-gb/sections/23595084748573-Drupal-integration

* For information about the Mediaflow platform, visit:
  https://www.mediaflow.com

## RECOMMENDED MODULES

* The Drupal core Media system must be enabled for asset usage.
* No other additional modules are strictly required.
* The Mediaflow module support the Content-Security-Policy module
  (https://www.drupal.org/project/csp) and automatically allows usage of
  Mediaflow resources.

  The Content-Security-Policy header allows your Drupal site to inform browsers
  of trusted sources for JavaScript, CSS, and other external resources. This
  adds a security layer to detect and mitigate the risk of Cross Site Scripting
  (XSS), data injection, and other vulnerabilities.

## INSTALLATION

* Install this module as usual. See the Drupal documentation for installing
  contributed modules:
  https://www.drupal.org/docs/extending-drupal/installing-modules

* After installation, enable the module from the Extend page or via
  Drush: drush en mediaflow

## CONFIGURATION

* Navigate to:
  Configuration → Media → Mediaflow settings (/admin/config/media/mediaflow)

* Enter your Mediaflow API credentials (API Key, API Secret and Refresh token).

* Save the configuration. Editors will then be able to browse and import
  Mediaflow assets through the Media Library or Entity Browser, depending on
  their shared folder in Mediaflow.

## TROUBLESHOOTING

* If no assets appear, verify that your Mediaflow credentials are correct and
  that your account has permission to access the relevant libraries.

* If media imports fail, ensure that the Drupal file system is correctly
  configured and writable.

* For a more detailed guide on how to install and use this module, refer to:
  https://help.mediaflow.com/hc/en-gb/sections/23595084748573-Drupal-integration

## MAINTAINERS & CONTRIBUTION

* Mediaflow – https://mediaflow.com

* Contributions, feedback, and issue reports are welcome.
  https://www.drupal.org/project/issues/mediaflow
