/* eslint-disable import/no-extraneous-dependencies */
/* cspell:ignore insertfileselector */

import { Plugin } from 'ckeditor5/src/core';
import { toWidget, toWidgetEditable } from 'ckeditor5/src/widget';
import { Widget } from 'ckeditor5/src/widget';
import InsertFileselectorCommand from './insertfileselector';

/**
 * The Mediaflow editing plugin.
 *
 * Registers the `insertFileselector` command.
 *
 * @extends module:core/plugin~Plugin
 */
export default class FileselectorEditing extends Plugin {
  static get requires() {
    return [Widget];
  }

  init() {
    this._defineSchema();
    this._defineConverters();
    this.editor.commands.add(
      'insertFileselector',
      new InsertFileselectorCommand(this.editor),
    );
  }
  _defineSchema() {
    // Schemas are registered via the central `editor` object.
    const schema = this.editor.model.schema;

    schema.register('fileselector', {
      // Behaves like a self-contained object (e.g. an image).
      isObject: true,
      // Allow in places where other blocks are allowed (e.g. directly in the root).
      allowWhere: '$block',
    });


    schema.register('fileselectorDescription', {
      isLimit: true,
      allowIn: 'fileselector',
      allowContentOf: '$root',
    });

    schema.addChildCheck((context, childDefinition) => {
      if (
        context.endsWith('fileselectorDescription') &&
        childDefinition.name === 'fileselector'
      ) {
        return false;
      }
    });
  }

  _defineConverters() {

    const { conversion } = this.editor;

    conversion.for('upcast').elementToElement({
      model: 'fileselector',
      view: {
        name: 'div',
        classes: 'mediaflow-media',
      },
    });
    conversion.for('dataDowncast').elementToElement({
      model: 'fileselector',
      view: {
        name: 'div',
        classes: 'mediaflow-media',
      },
    });
    conversion.for('editingDowncast').elementToElement({
      model: 'fileselector',
      view: (modelElement, { writer: viewWriter }) => {
        const div = viewWriter.createEditableElement('div', {
          class: 'mediaflow-media',
        });
        return toWidgetEditable(div, viewWriter);
      },
    });
  }
}
