/**
 * @file registers the Mediaflow toolbar button and binds functionality to it.
 */

import { Plugin } from 'ckeditor5/src/core';
import { ButtonView } from 'ckeditor5/src/ui';

export default class FileselectorUI extends Plugin {
  init() {
    const editor = this.editor;

    // This will register the Mediaflow toolbar button.
    editor.ui.componentFactory.add('fileselector', (locale) => {
      const command = editor.commands.get('insertFileselector');
      const buttonView = new ButtonView(locale);

      // Create the toolbar button.
      buttonView.set({
        label: editor.t('Insert media from Mediaflow'),
        tooltip: true,
        class: 'mediaflow-fileselector',
      });

      // Bind the state of the button to the command.
      buttonView.bind('isOn', 'isEnabled').to(command, 'value', 'isEnabled');

      // Execute the command when the button is clicked (executed).
      this.listenTo(buttonView, 'execute', () =>
        editor.execute('insertFileselector'),
      );

      return buttonView;
    });
  }
}
