/* eslint-disable import/no-extraneous-dependencies */

import { Command } from 'ckeditor5/src/core';

export default class InsertFileselectorCommand extends Command {
  execute() {
    const { model } = this.editor;
    const domEditableElement = document.querySelector( '.ck-editor__editable_inline' );
    const editorInstance = domEditableElement.ckeditorInstance;
    let settings = this.editor.config.get('mediaflow');

    let fileSelector;

    let backDrop = document.createElement('div');
    backDrop.classList.add('mediaflow-ckeditor-backdrop');
    document.body.appendChild(backDrop);

    let modal = document.createElement('div');
    modal.id = 'mediaflow-ckeditor-modal';
    modal.classList.add('mediaflow-ckeditor-modal');
    document.body.appendChild(modal);

    let selector = document.createElement('div');
    selector.id = 'mediaflow-ckeditor-browser';
    selector.classList.add('mediaflow-ckeditor-browser');
    modal.appendChild(selector);

    backDrop.onclick = function(){
      document.body.removeChild(backDrop);
      document.body.removeChild(modal);
    };

    fetch(settings.tokenEndpoint)
      .then(response => response.json())
      .then(token => initiateFileSelector(token));

    function initiateFileSelector (token) {
      settings.auth = 'accesstoken';
      settings.accesstoken = token;
      settings.success = function (data) {
        saveImage(data);
      };
      fileSelector = new FileSelector('mediaflow-ckeditor-browser', settings);
    }

    function saveImage(data) {
      data.bundle = settings.media_bundle;
      fetch('/mediaflow/add_media?mediaflow-info='+JSON.stringify(data))
        .then(response => response.json())
        .then(data =>
          insertImageInEditor(data)
        )
    }

    function insertImageInEditor(data) {
      editorInstance.editing.view.change( writer => {
        editorInstance.execute('insertDrupalMedia', {
          'data-entity-type': data['data-entity-type'],
          'data-entity-uuid': data['data-entity-uuid'],
          'data-view-mode': 'default',
          'alt': data['alt'],
        });
      });

      document.body.removeChild(backDrop);
      document.body.removeChild(modal);
    }

  }

  refresh() {
    const { model } = this.editor;
    const { selection } = model.document;

    const allowedIn = model.schema.findAllowedParent(
      selection.getFirstPosition(),
      'fileselector',
    );
    this.isEnabled = allowedIn !== null;
  }
}

function createFileselector(writer) {

  const fileselectorDescription = writer.createElement('fileselector');
  writer.append(fileSelectorDescription, fileselector);
  return fileselector;
}
