/**
 * @file
 * Script for the mediaflow image/video selector
 */

(function ($, Drupal, once) {
  'use strict';
  Drupal.behaviors.mediaFlowPicker = {
    attach: function (context) {
      if ($(context).find('.mediaflow-widget-wrapper-file').length > 0) {
        $('.remove-mediaflow-button').on('click', function () {
          $(this).parents('.mediaflow-widget-wrapper-file').find('[data-mediaflow-target]').val(0);

          $(this).parents('.mediaflow-widget-wrapper-file').find('img').remove();
          $(this).parents('.mediaflow-widget-wrapper-file').siblings('img').remove();

          $(this).parents('.mediaflow-widget-wrapper-file').find('.plyr').remove();
          $(this).parents('.mediaflow-widget-wrapper-file').siblings('.plyr').remove();

          $(this).parents('.mediaflow-widget-wrapper-file').find('.mediaflow-video').remove();
          $(this).parents('.mediaflow-widget-wrapper-file').siblings('.mediaflow-video').remove();

          $(this).parents('.mediaflow-widget-wrapper-file').find('.remove-mediaflow-button').hide();
        });

        once('mediaflow-button', '.pick-mediaflow-button', context).forEach(function (element) {
          $(element).on('click', function () {
            let $this = $(this),
              $preview = $this.parents('.mediaflow-widget-wrapper-file').find('.mediaflow-file'),
              $input = $this.parents('.mediaflow-widget-wrapper-file').find('[data-mediaflow-target]');

            let settings = {};
            $.extend(settings, drupalSettings.mediaflow);
            $.extend(settings, {
              success: function (response) {
                $preview.show();
                $preview.html('');
                $this.parents('.mediaflow-widget-wrapper-file').find('img').remove();
                $this.parents('.mediaflow-widget-wrapper-file').siblings('img').remove();

                if (response.basetype === 'video') {
                  let mediaElement = document.createElement('div');
                  mediaElement.classList = 'mediaflow-video';
                  mediaElement.innerHTML = response.embedCode;
                  $preview.append(mediaElement);
                }
                else {
                  let mediaElement = document.createElement('img');
                  mediaElement.setAttribute('src', response.url);
                  $preview.append(mediaElement);
                }

                $input
                  .val(JSON.stringify(response))
                  .trigger('change');

                backDrop.detach();
                modal.detach();
              },
            });

            let fileSelector;
            let backDrop = $('<div />')
              .addClass('mediaflow-ckeditor-backdrop');

            let modal = $('<div />')
              .attr('id', 'mediaflow-ckeditor-modal')
              .addClass('mediaflow-ckeditor-modal');

            let selector = $('<div />')
              .attr('id', 'mediaflow-ckeditor-browser')
              .addClass('mediaflow-ckeditor-browser')
              .appendTo(modal);

            backDrop.click(function () {
              backDrop.detach();
              modal.detach();
            });

            $('body').append(backDrop).append(modal);
            $.ajax({
              url: settings.tokenEndpoint,
              success: function (token) {
                $.extend(settings, {
                  auth: 'accesstoken',
                  accesstoken: token
                });
                fileSelector = new FileSelector(selector.attr('id'), settings);
              }
            });
          });
        });
      }
    },
    detach: function (context) {
      if ($(context).find('.mediaflow-widget-wrapper-file').length > 0) {
        $('.remove-mediaflow-button').off('click');
      }
    },

  };

  $.fn.mediaFlowBrowser = function () {
    this.each(function () {
      let settings = {};
      let container = $(this);
      let fileSelector;

      $.extend(settings, drupalSettings.mediaflow);
      $.extend(settings, {
        success: function (response) {
          $('[data-mediaflow-target]')
            .val(JSON.stringify(response))
            .trigger('change');
          $('[data-drupal-selector="edit-submit"]').click();
        },
      });
      $.ajax({
        url: settings.tokenEndpoint,
        success: function (token) {
          $.extend(settings, {
            auth: 'accesstoken',
            accesstoken: token
          });
          fileSelector = new FileSelector(container.attr('id'), settings);
        }
      });
      $('[data-drupal-selector="edit-submit"]').hide();
    });
  };

  Drupal.behaviors.mediaFlowSelector = {
    attach: function (context) {
      let editor = document.querySelectorAll('.mediaflow-file');
      once('mediaflow', '[data-mediaflow-selector]', context).forEach(function (el) {
        $(el).mediaFlowBrowser();
      });
    },
  };
})(jQuery, Drupal, once);
