<?php

declare(strict_types=1);

namespace Drupal\mediaflow;

use Drupal\Core\DependencyInjection\ContainerBuilder;
use Drupal\Core\DependencyInjection\ServiceProviderBase;

/**
 * Service provider for mediaflow.
 */
final class MediaflowServiceProvider extends ServiceProviderBase {

  /**
   * {@inheritdoc}
   */
  public function alter(ContainerBuilder $container) {
    // We cannot use the module handler as the container is not yet compiled.
    // @see \Drupal\Core\DrupalKernel::compileContainer()
    $modules = $container->getParameter('container.modules');

    if (!isset($modules['csp'])) {
      $container->removeDefinition('mediaflow.csp_subscriber');
    }
  }

}
