<?php

namespace Drupal\mediaflow\Plugin\Field\FieldType;

use Drupal\Core\Field\FieldItemBase;
use Drupal\Core\Field\FieldItemInterface;
use Drupal\Core\Field\FieldStorageDefinitionInterface;
use Drupal\Core\TypedData\DataDefinition;

/**
 * Provides a field for Mediaflow plugin.
 *
 * @FieldType(
 *   id = "mediaflow_item",
 *   label = @Translation("Mediaflow"),
 *   description = @Translation("Field to upload an image or video from Mediaflow"),
 *   default_widget = "mediaflow_default",
 *   default_formatter = "mediaflow_default",
 * )
 */
class MediaflowItem extends FieldItemBase implements FieldItemInterface {

  /**
   * {@inheritdoc}
   */
  public static function schema(FieldStorageDefinitionInterface $field_definition) {
    $output = [];
    $output['columns']['value'] = [
      'type' => 'varchar',
      'length' => 2048,
    ];

    return $output;
  }

  /**
   * {@inheritdoc}
   */
  public static function propertyDefinitions(FieldStorageDefinitionInterface $field_definition) {
    $properties['value'] = DataDefinition::create('string')
      ->setLabel(t('Media'))
      ->setRequired(FALSE);
    return $properties;
  }

  /**
   * {@inheritdoc}
   */
  public function isEmpty() {
    $item = $this->getValue();
    $has_stuff = FALSE;
    if (!empty($item['value'])) {
      $has_stuff = TRUE;
    }
    return !$has_stuff;
  }

}
