<?php

namespace Drupal\mediaflow\Service;

/**
 * Implements Mediaflow Fetcher interface.
 */
interface MediaflowFetcherInterface {

  const API_URL = 'https://api.mediaflow.com/1';

  /**
   * Download file from API.
   *
   * @param array $data
   *   Data to be downloaded.
   *
   * @return \Drupal\file\Entity\File|null
   *   File entity, otherwise NULL.
   */
  public function downloadFile(array $data);

  /**
   * Updates file usage.
   *
   * @param array $data
   *   File data.
   *
   * @return array
   *   Response.
   */
  public function updateUsages(array $data);

  /**
   * Deletes file usage.
   *
   * @param array $data
   *   File data.
   *
   * @return array
   *   Response.
   */
  public function deleteUsage(array $data);

  /**
   * Renews access tokens if necessary.
   *
   * @param bool $refresh
   *   TRUE to force token refresh.
   *
   * @return string|null
   *   Token or null.
   */
  public function getAccessToken(bool $refresh = FALSE);

  /**
   * Clears stored access token.
   */
  public function clearAccessToken();

  /**
   * Renews access tokens if necessary.
   */
  public function ensureAccess();

}
