<?php

namespace Drupal\mediaflow\Service;

use Drupal\Core\Entity\EntityInterface;

/**
 * Implements Usage Manager interface.
 */
interface UsageManagerInterface {

  const FILE = 1;
  const EMBED = 2;

  const MEDIAFLOW_FIELD_TYPES = [
    'mediaflow_item',
  ];

  const REFERENCE_FIELD_TYPES = [
    'entity_reference',
    'entity_reference_revisions',
  ];

  const MEDIA_EMBED_FIELD_TYPES = [
    'text',
    'text_long',
    'text_with_summary',
  ];

  /**
   * Retrieves the Mediaflow Fetcher.
   *
   * @return \Drupal\mediaflow\Service\MediaflowFetcher
   *   Mediaflow Fetcher instance.
   */
  public function getFetcher();

  /**
   * Downloads media from Mediaflow.
   *
   * @param array $data
   *   Mediaflow data.
   */
  public function downloadUri(array &$data);

  /**
   * Prepare and save Mediaflow data.
   *
   * @param array $data
   *   Mediaflow data.
   *
   * @return \Drupal\Core\Database\StatementInterface|false|int|string|null
   *   Result of operation.
   */
  public function addMedia(array $data);

  /**
   * Adds Mediaflow record.
   *
   * @param array $data
   *   Data to store.
   *
   * @return \Drupal\Core\Database\StatementInterface|false|int|string|null
   *   Result of operation.
   */
  public function saveMediaData(array $data);

  /**
   * Gets Mediaflow record value.
   *
   * @param string $id
   *   Record ID.
   * @param string $key
   *   Field name.
   *
   * @return false|mixed
   *   Field value or false.
   */
  public function getValue(string $id, string $key);

  /**
   * Reacts on entity create.
   *
   * @param \Drupal\Core\Entity\EntityInterface $entity
   *   Entity to be created.
   */
  public function onEntityCreate(EntityInterface $entity);

  /**
   * Reacts on entity update.
   *
   * @param \Drupal\Core\Entity\EntityInterface $entity
   *   Entity to be updated.
   */
  public function onEntityUpdate(EntityInterface $entity);

  /**
   * Reacts on entity delete.
   *
   * @param \Drupal\Core\Entity\EntityInterface $entity
   *   Entity to be deleted.
   */
  public function onEntityDelete(EntityInterface $entity);

}
