# Meeting API

⚠️ **Module on current development** ⚠️

The module provides tools to manage meetings based on different backends, creating
a uniform solution for meetings across different technologies in a Drupal based
system.

**At present, this module provides API features but does not implement any permission logic.**

## Requirements

This module requires the following other modules:

- [datetime_range_timezone](https://www.drupal.org/project/datetime_range_timezon)

## Installation

Install as you would normally install a contributed Drupal module. For further
information, see
[Installing Drupal Modules](https://www.drupal.org/docs/extending-drupal/installing-drupal-modules).

## API

## Entities

### Server (config)

Servers are entities used to store information about the backend running the meetings.

Each server is related to a backend that determines the type of technology used
to host the meetings. Backends can be set in servers as plugins from this module
or any other module that implements a plugin under the *MeetingApiBackend* namespace.

### Meeting type (content)

This is a bundle for meeting entities, allowing you to create different types of
meetings, each tied to a specific server.

### Meeting (content)

This is an entity to store meeting-specific information with fields like start
and end date, maximum attendees, or backend. Backends can be set as plugins from
this module or any other that implements a *MeetingApiBackend* plugin.

### Services

#### Meeting manager

Adds uniform standardized methods to perform actions in meetings like join to a
given meeting.

Methods available:

- _joinMeeting_: joins a user to a meeting. Requires the meeting to join and the
  attendee information (context in the meeting for the user to join).

**Important note**: this methods are tied to independent interfaces and not the entities
exposed above, which extend the required interfaces.

## Modules

### Meeting API Manual URL

Provides a backend plugin that allows to specify a single URL for joining meetings.

## Updating locked values in meeting server or meeting type

When creating a meeting server or meeting type in the UI, the user can choose from
the available options for the backend or server.

Once created, this choice is locked, and cannot be changed using the edit form.\

This is to avoid disruption in existing meetings.

For a meeting type or server ("entity") that is not yet used anywhere, the easiest
way to change these locked values is to delete and recreate that entity, using the UI.\

This change can then be deployed to production using config export and import.

For an entity that is already being used in existing meeting types and meetings,
the dependency can only be changed programmatically using an update hook.\

Such an update hook would need to carefully migrate the settings for all existing
meetings and meeting types that are affected by the change.

## Contributing

[DDEV](https://ddev.com), a Docker-based PHP development tool for a streamlined
and unified development process, is the recommended tool for contributing to the
module. The [DDEV Drupal Contrib](https://github.com/ddev/ddev-drupal-contrib)
addon makes it easy to develop a Drupal module by offering the tools to set up
and test the module.

### Development configuration

Inside the cloned project run:

```shell
# Fire up the Docker containers.
ddev start
# Install the PHP dependencies.
ddev poser
# Symlink the module inside "web/modules/custom".
ddev symlink-project
# Install Drupal and enable the module.
ddev install
# Run this if you want to use the eslint command.
ddev exec "cd web/core && yarn install"
```

### Changing the Drupal core version

* Create a file`.ddev/config.local.yaml`
* Set the desired Drupal core version. E.g.:

  ```yaml
  web_environment:
    - DRUPAL_CORE=^10.3
  ```
* Run`ddev restart`

### Run tests

```shell
# Run PHPUnit tests.
ddev phpunit
# Run PHP coding standards checks.
ddev phpcs
# Fix coding standards findings.
ddev phpcbf
# Run PHP static analysis.
ddev phpstan
# Run ESLint on Javascript and YAML files.
ddev eslint
```
