<?php

declare(strict_types=1);

namespace Drupal\meeting_api_manual\PluginForm;

use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Plugin\PluginFormBase;
use Drupal\Core\StringTranslation\StringTranslationTrait;
use Drupal\meeting_api\MeetingInterface;

/**
 * Configuration form for the "meeting" action of manual backend.
 */
class ManualMeetingConfigurationForm extends PluginFormBase {

  use StringTranslationTrait;

  /**
   * {@inheritdoc}
   */
  public function buildConfigurationForm(array $form, FormStateInterface $form_state) {
    $entity = $form_state->get('meeting_entity');
    assert($entity instanceof MeetingInterface);
    $configuration = $entity->getSettings();

    $form['url'] = [
      '#type' => 'url',
      '#required' => TRUE,
      '#title' => $this->t('Meeting URL'),
      '#description' => $this->t('The URL of the meeting.'),
      '#default_value' => $configuration['url'] ?? FALSE,
    ];

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function submitConfigurationForm(array &$form, FormStateInterface $form_state) {
    // No extra submit needed.
  }

}
