<?php

declare(strict_types=1);

namespace Drupal\meeting_api;

use Drupal\Core\Cache\CacheBackendInterface;
use Drupal\Core\Extension\ModuleHandlerInterface;
use Drupal\Core\Plugin\DefaultPluginManager;
use Drupal\meeting_api\Attribute\Backend;

/**
 * Backend plugin manager.
 */
class BackendPluginManager extends DefaultPluginManager {

  /**
   * Constructs the object.
   */
  public function __construct(\Traversable $namespaces, CacheBackendInterface $cache_backend, ModuleHandlerInterface $module_handler) {
    parent::__construct('Plugin/MeetingApiBackend', $namespaces, $module_handler, BackendInterface::class, Backend::class);
    $this->alterInfo('meeting_api_backend_info');
    $this->setCacheBackend($cache_backend, 'meeting_api_backend_plugins');
  }

}
