<?php

namespace Drupal\meeting_api;

/**
 * Interface for meeting managers.
 */
interface MeetingManagerInterface {

  /**
   * Joins a user to a meeting.
   *
   * @param \Drupal\meeting_api\MeetingInterface $meeting
   *   The meeting to join to.
   * @param \Drupal\meeting_api\MeetingAttendeeInterface $user
   *   The user to join the meeting.
   *
   * @return string
   *   The URL of the meeting.
   *
   * @throws \Drupal\meeting_api\Exception\OperationException
   *   Thrown when the operation fails.
   */
  public function joinMeeting(MeetingInterface $meeting, MeetingAttendeeInterface $user): string;

}
