<?php

declare(strict_types=1);

namespace Drupal\meeting_api_test\Plugin\MeetingApiBackend;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\meeting_api\Attribute\Backend;
use Drupal\meeting_api_test\PluginForm\BarMeetingConfigurationForm;

/**
 * A simple test plugin called Bar.
 *
 * This plugin offers no server configuration form, only a meeting configuration
 * form.
 */
#[Backend(
  id: 'bar',
  label: new TranslatableMarkup('Bar'),
  description: new TranslatableMarkup('Bar description.'),
  forms: [
    'meeting' => BarMeetingConfigurationForm::class,
  ]
)]
class Bar extends TestBackendBase {

  /**
   * {@inheritdoc}
   */
  public function defaultConfiguration(): array {
    return [];
  }

}
