<?php

declare(strict_types=1);

namespace Drupal\Tests\meeting_api\Traits;

use Behat\Mink\Element\Element;
use Behat\Mink\Element\NodeElement;

/**
 * Contains methods that help asserting options in Drupal elements.
 */
trait AssertOptionsTrait {

  /**
   * Asserts that a radios element contains only the expected radio inputs.
   *
   * @param \Behat\Mink\Element\NodeElement $fieldset
   *   The fieldset that represents the Drupal "radios" element.
   * @param array $expected
   *   Either the label, ID or name of each of the expected radio inputs.
   */
  protected function assertRadiosOptions(NodeElement $fieldset, array $expected): void {
    $this->assertSameSize($expected, $fieldset->findAll('css', 'input'));
    // We cannot collect all the existing inputs correctly, as named radio
    // selector matches also on ID or name.
    foreach ($expected as $label) {
      $this->assertSession()->elementExists('named', ['radio', $label], $fieldset);
    }
  }

  /**
   * Asserts that a select element contains only the expected options.
   *
   * @param array $expected
   *   The list of expected options.
   * @param string $select
   *   The select element.
   * @param \Behat\Mink\Element\Element $container
   *   (optional) Container element to check against. Defaults to current page.
   */
  protected function assertSelectOptions(array $expected, string $select, ?Element $container = NULL): void {
    $select = $this->assertSession()->selectExists($select, $container);

    $options = [];
    /** @var \Behat\Mink\Element\NodeElement $option */
    foreach ($select->findAll('xpath', '//option') as $option) {
      $label = $option->getText();
      $value = $option->getAttribute('value') ?: $label;
      $options[$value] = $label;
    }

    $this->assertEquals($expected, $options);
  }

}
