<?php

namespace Drupal\meeting_api;

/**
 * Interface for users in meetings.
 */
interface MeetingAttendeeInterface {

  /**
   * Role used for standard user in a meeting.
   */
  const ATTENDEE_ROLE = 'attendee';

  /**
   * Role used for higher permissions user that manages a meeting.
   */
  const MODERATOR_ROLE = 'moderator';

  /**
   * Gets the user ID in a meeting.
   *
   * @return string
   *   The ID of the user.
   */
  public function getId(): string;

  /**
   * Gets the user name in a meeting.
   *
   * @return string
   *   The name of the user.
   */
  public function getName(): string;

  /**
   * Gets the user role in a meeting.
   *
   * @return string
   *   The role of the user.
   */
  public function getMeetingRole(): string;

}
