<?php

declare(strict_types=1);

namespace Drupal\meeting_api_test\Plugin\MeetingApiBackend;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\meeting_api\Attribute\Backend;

/**
 * A simple plugin with no forms provided.
 */
#[Backend(
  id: 'simple_no_forms',
  label: new TranslatableMarkup('Simple plugin without forms'),
  description: new TranslatableMarkup('Plugin that has no configuration form.'),
)]
class SimplePluginWithoutForms extends TestBackendBase {

  /**
   * {@inheritdoc}
   */
  public function defaultConfiguration() {
    return [];
  }

}
