<?php

declare(strict_types=1);

namespace Drupal\meeting_api_test\PluginForm;

use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Plugin\PluginFormBase;
use Drupal\Core\StringTranslation\StringTranslationTrait;
use Drupal\meeting_api\MeetingInterface;

/**
 * Configuration form for the "meeting" action of bar backend.
 */
class BarMeetingConfigurationForm extends PluginFormBase {

  use StringTranslationTrait;

  /**
   * {@inheritdoc}
   */
  public function buildConfigurationForm(array $form, FormStateInterface $form_state): array {
    $entity = $form_state->get('meeting_entity');
    assert($entity instanceof MeetingInterface);
    $configuration = $entity->getSettings();

    $form['mode'] = [
      '#type' => 'radios',
      '#title' => $this->t('Mode'),
      '#options' => [
        'one' => $this->t('One'),
        'two' => $this->t('Two'),
        'three' => $this->t('Three'),
      ],
      '#default_value' => $configuration['mode'] ?? 'one',
    ];

    $form['ignore_me'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Ignore this field'),
      '#description' => $this->t('Ignore this field or validation will fail.'),
      '#default_value' => $configuration['ignore_me'] ?? '',
    ];

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function validateConfigurationForm(array &$form, FormStateInterface $form_state) {
    parent::validateConfigurationForm($form, $form_state);

    if ($form_state->getValue('ignore_me', '') !== '') {
      $form_state->setError($form['ignore_me'], $this->t('Ignore field should be kept empty.'));
    }
  }

  /**
   * {@inheritdoc}
   */
  public function submitConfigurationForm(array &$form, FormStateInterface $form_state) {
    $form_state->unsetValue('ignore_me');
  }

}
