<?php

declare(strict_types=1);

namespace Drupal\meeting_api;

/**
 * Provides an interface defining a meeting.
 */
interface MeetingInterface {

  /**
   * Constant for a meeting without attendee number limit.
   */
  public const ATTENDEES_UNLIMITED = 0;

  /**
   * Gets the label of the entity.
   *
   * @return string|\Drupal\Core\StringTranslation\TranslatableMarkup|null
   *   The label of the entity, or NULL if there is no label defined.
   */
  public function label();

  /**
   * Gets the server ID related to the meeting.
   *
   * @return string
   *   The ID of the server.
   */
  public function getServerId(): string;

  /**
   * Gets the meeting identifier.
   *
   * @return string
   *   The ID of the meeting.
   */
  public function getIdentifier(): string;

  /**
   * Returns the meeting settings.
   *
   * @return array
   *   The meeting settings.
   */
  public function getSettings(): array;

}
