<?php

declare(strict_types=1);

namespace Drupal\meeting_api_test\PluginForm;

use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Plugin\PluginFormBase;
use Drupal\Core\StringTranslation\StringTranslationTrait;
use Drupal\meeting_api\BackendInterface;

/**
 * Configuration form for the "configure" operation of acme backend.
 */
class AcmeServerConfigurationForm extends PluginFormBase {

  use StringTranslationTrait;

  /**
   * {@inheritdoc}
   */
  public function buildConfigurationForm(array $form, FormStateInterface $form_state): array {
    assert($this->plugin instanceof BackendInterface);
    $configuration = $this->plugin->getConfiguration();

    $form['url'] = [
      '#type' => 'url',
      '#title' => $this->t('Acme URL'),
      '#required' => TRUE,
      '#default_value' => $configuration['url'],
    ];

    $form['key'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Acme Key'),
      '#required' => TRUE,
      '#default_value' => $configuration['key'],
    ];

    $form['mode'] = [
      '#type' => 'select',
      '#title' => $this->t('Acme mode'),
      '#options' => [
        'megazord' => 'Megazord',
        'gigazord' => 'Gigazord',
        'ultrazord' => 'Ultrazord',
      ],
      '#default_value' => $configuration['mode'],
    ];

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function validateConfigurationForm(array &$form, FormStateInterface $form_state) {
    if ($form_state->getValue('mode') === 'ultrazord') {
      $form_state->setError($form['mode'], $this->t('Ultrazord mode: overpower detected!!!'));
    }
  }

  /**
   * {@inheritdoc}
   */
  public function submitConfigurationForm(array &$form, FormStateInterface $form_state): void {
    $configuration = [];
    // Add some value processing to test the submit configuration form.
    $configuration['url'] = $form_state->getValue('mode') === 'gigazord'
      ? 'http://www.gigaserver.com/'
      : $form_state->getValue('url');
    $configuration['key'] = $form_state->getValue('key');
    $configuration['mode'] = $form_state->getValue('mode');

    // @todo Add a base class for backend plugin forms.
    assert($this->plugin instanceof BackendInterface);
    $this->plugin->setConfiguration($configuration);
  }

}
