<?php

declare(strict_types=1);

namespace Drupal\Tests\meeting_api\Traits;

use Drupal\FunctionalJavascriptTests\WebDriverTestBase;

/**
 * Contains helper methods to handle meeting forms.
 */
trait MeetingFormTrait {

  /**
   * Helper method to fill the start and end date fields.
   *
   * Do not use this method to run assertions. Use it only to fill quickly the
   * fields. Only the label can be used to assert create/write messages.
   *
   * @return string
   *   The label of the meeting.
   */
  protected function fillMeetingMandatoryFields(): string {
    // Tests with a JS-enabled browser require a different format for date and
    // time: MM-DD-YYYY and H:i:sA.
    // @todo Find a better way: this is tied to the Chromium image we are using.
    $is_js = $this instanceof WebDriverTestBase;

    $values = [
      'datetime[0][value][date]' => $is_js ? '10-05-2020' : '2020-10-05',
      'datetime[0][value][time]' => $is_js ? '12:00:00PM' : '12:00:00',
      'datetime[0][end_value][date]' => $is_js ? '10-07-2020' : '2020-10-07',
      'datetime[0][end_value][time]' => $is_js ? '06:00:00PM' : '18:00:00',
    ];

    $label = $this->randomMachineName();
    $assert_session = $this->assertSession();
    $assert_session->fieldExists('Label')->setValue($label);
    foreach ($values as $name => $value) {
      $assert_session->fieldExists($name)->setValue($value);
    }

    return $label;
  }

}
