<?php

declare(strict_types=1);

namespace Drupal\meeting_api_manual\Plugin\MeetingApiBackend;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\meeting_api\Attribute\Backend;
use Drupal\meeting_api\BackendPluginBase;
use Drupal\meeting_api\MeetingAttendeeInterface;
use Drupal\meeting_api\MeetingInterface;
use Drupal\meeting_api_manual\PluginForm\ManualMeetingConfigurationForm;

/**
 * A backend that allows to specify a single URL for joining meetings.
 */
#[Backend(
  id: 'manual',
  label: new TranslatableMarkup('Manual URL'),
  description: new TranslatableMarkup('A single URL.'),
  forms: [
    'meeting' => ManualMeetingConfigurationForm::class,
  ]
)]
class Manual extends BackendPluginBase {

  /**
   * {@inheritdoc}
   */
  public function defaultConfiguration() {
    return [];
  }

  /**
   * {@inheritdoc}
   */
  public function joinMeeting(MeetingInterface $meeting, MeetingAttendeeInterface $user): string {
    return $meeting->getSettings()['url'];
  }

}
